/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

define([ "jquery", "backbone", "modules/navigation/NavItem" ], function ($, Backbone, Model) {
    'use strict';
    return Backbone.Collection.extend({
        model : Model,
        sort_key : "type",
        initialize: function () {
            return undefined;
        },
        parse: function (response) {
            return response.favoriteItems;
        },
        convertTypeToSortWeight: function (type) {
            var weight;
            if (type === 'App') {
                weight = 1;
            } else if (type === 'Applet') {
                weight = 0;
            } else {
                weight = 2;
            }
            return weight;
        },
        comparator: function (item1, item2) {
            var sortKey = this.sort_key,
                item1weight = item1.get(sortKey),
                item2weight = item2.get(sortKey),
                item1weight2 = item1.get('name'),
                item2weight2 = item2.get('name');
            if (sortKey === 'type') {
                item1weight = this.convertTypeToSortWeight(item1weight);
                item2weight = this.convertTypeToSortWeight(item2weight);
            }
            return item1weight > item2weight ?  1 : ((item1weight < item2weight) ? -1 : (item1weight2 > item2weight2 ? 1 : (item1weight2 < item2weight2 ? -1 : 0)));
        },
        sortByName: function () {
            this.sort_key = 'name';
            this.sort();
        },
        sortByType: function () {
            this.sort_key = 'type';
            this.sort();
        }
    });
});